function dpdt = EqFunc(t,p)  %#ok<*STOUT> 

global m n gamma Aeff Vref ...
       V lambda alpha  %#ok<*GVMIS>

dpdt=zeros(m+n,1);


for i = 1 : m+n
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % indexes i=1:n correspond to the backward-propagating pump waves
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if i>=1 && i<=n
        alpha(i) = Calalpha(lambda(i)); %#ok<*AGROW>
        dpdt(i,1) = alpha(i)*p(i);
        % ------------------------------------------ %
        sum=0;
        for j=1:i-1
            gr=Calgr(V(j),V(i));
            g(j,i)=(V(j)/Vref)*gr;
            sum=sum+(g(j,i)/(gamma*Aeff))*p(j)*p(i);
        end
        dpdt(i,1)=dpdt(i)-sum;
        % ------------------------------------------ %
        sum=0;
        for j=i+1:n+m
            gr=Calgr(V(i),V(j));
            g(i,j)=(V(i)/Vref)*gr;
            sum=sum+(V(i)/V(j))*(g(i,j)/(gamma*Aeff))*p(j)*p(i);
        end
        dpdt(i,1)=dpdt(i)+sum;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % indexes i=n+1:n+m correspond to the forward-propagating signal waves
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if i>=n+1 && i<=n+m
        alpha(i) = Calalpha(lambda(i));
        dpdt(i,1) = -alpha(i)*p(i);
        % ------------------------------------------ %
        sum=0;
        for j=1:i-1
            gr=Calgr(V(j),V(i));
            g(j,i)=(V(j)/Vref)*gr;
            sum=sum+(g(j,i)/(gamma*Aeff))*p(j)*p(i);
        end
        dpdt(i,1)=dpdt(i)+sum;
        % ------------------------------------------ %
        sum=0;
        for j=i+1:n+m
            gr=Calgr(V(i),V(j));
            g(i,j)=(V(i)/Vref)*gr;
            sum=sum+(V(i)/V(j))*(g(i,j)/(gamma*Aeff))*p(j)*p(i);
        end
        dpdt(i,1)=dpdt(i)-sum;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end


end



